/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class EntityStatsDump {
    private static String newline = new String(System.getProperty("line.separator").getBytes());

    private static String customFloatFormat(float f2) {
        if (f2 < 1.0f && (double)f2 != 0.0) {
            return StringHelper.formatFloat(f2, 2, 2);
        }
        return StringHelper.formatFloat(f2, 1, 1);
    }

    private static String getItemStackDescriptorForStatsFile(ye item_stack) {
        if (item_stack == null) {
            return "(nothing)";
        }
        StringBuilder sb2 = new StringBuilder();
        sb2.append(item_stack.getNameForReferenceFile());
        if (item_stack.b != 1) {
            sb2.append(" (" + item_stack.b + ")");
        }
        String[] notes = new String[16];
        EnumQuality quality = item_stack.getQuality();
        if (quality != null && !quality.isAverage()) {
            StringHelper.addToStringArray(quality.getDescriptor(), notes);
        }
        if (item_stack.y()) {
            Map enchantments = aaw.getEnchantmentsMap(item_stack);
            Set set = enchantments.entrySet();
            for (Map.Entry e2 : set) {
                aau enchantment = aau.get((Integer)e2.getKey());
                int level = (Integer)e2.getValue();
                StringHelper.addToStringArray(enchantment.getTranslatedName(level, item_stack), notes);
            }
        }
        if (notes[0] != null) {
            sb2.append(" {");
            sb2.append(StringHelper.implode(notes, ", ", true, false));
            sb2.append("}");
        }
        if (item_stack.i()) {
            sb2.append(" [" + item_stack.getRemainingDurability() + "/" + item_stack.l() + "]");
        }
        return sb2.toString();
    }

    private static void appendSectionProtection(of entity_living_base, StringBuilder sb2) {
        sb2.append("Protection" + newline);
        sb2.append(" vs Generic: " + EntityStatsDump.customFloatFormat(entity_living_base.getTotalProtection(nb.a(null))) + newline);
        sb2.append(" vs Falls: " + EntityStatsDump.customFloatFormat(entity_living_base.getTotalProtection(nb.h)) + newline);
        sb2.append(" vs Fire: " + EntityStatsDump.customFloatFormat(entity_living_base.getTotalProtection(nb.b)) + newline);
        sb2.append(" vs Explosions: " + EntityStatsDump.customFloatFormat(entity_living_base.getTotalProtection(new nb("explosion").d())) + newline);
        uh entity_arrow = new uh(entity_living_base.q);
        entity_arrow.item_arrow = yc.arrowFlint;
        sb2.append(" vs Projectiles: " + EntityStatsDump.customFloatFormat(entity_living_base.getTotalProtection(nb.a(entity_arrow, null))) + newline + newline);
    }

    private static void appendSectionResistance(of entity_living_base, StringBuilder sb2) {
        sb2.append("Resistance" + newline);
        sb2.append(" vs Poison: " + Math.round(entity_living_base.getResistanceToPoison() * 100.0f) + "%" + newline);
        sb2.append(" vs Paralysis: " + Math.round(entity_living_base.getResistanceToParalysis() * 100.0f) + "%" + newline);
        sb2.append(" vs Drain: " + Math.round(entity_living_base.getResistanceToDrain() * 100.0f) + "%" + newline);
        sb2.append(" vs Shadow: " + Math.round(entity_living_base.getResistanceToShadow() * 100.0f) + "%" + newline + newline);
    }

    private static void appendSectionPotionEffects(of entity_living_base, StringBuilder sb2) {
        sb2.append("Potion Effects" + newline);
        if (!entity_living_base.hasActivePotionEffects()) {
            sb2.append(" (none)" + newline + newline);
            return;
        }
        Collection potion_effects = entity_living_base.aL();
        for (nj potion_effect : potion_effects) {
            ni potion = ni.get(potion_effect.a());
            int level = potion_effect.c();
            sb2.append(" " + bkb.a(potion.a()));
            sb2.append(" " + StringHelper.getRomanNumeral(level + 1));
            Map attribute_modifiers = potion.k();
            Iterator iterator = attribute_modifiers.entrySet().iterator();
            String[] effect_descriptions = new String[16];
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                or attribute = (or)entry.getKey();
                ot modifier = (ot)entry.getValue();
                modifier = new ot(modifier.a(), modifier.b(), potion.a(level, modifier), modifier.c());
                String effect_details = yp.getEffectDetails(attribute.a(), modifier);
                if (effect_details == null) continue;
                StringHelper.addToStringArray(ma.a(effect_details), effect_descriptions);
            }
            if (effect_descriptions[0] != null) {
                sb2.append(" (" + StringHelper.implode(effect_descriptions, ", ", true, false) + ")");
            }
            sb2.append(" [" + ni.a(potion_effect) + "]");
            sb2.append(newline);
        }
        sb2.append(newline);
    }

    private static void appendSectionEquipment(of entity_living_base, StringBuilder sb2) {
        ye[] worn_items;
        sb2.append("Equipment" + newline);
        if (entity_living_base.getHeldItemStack() != null) {
            sb2.append(" Held: " + EntityStatsDump.getItemStackDescriptorForStatsFile(entity_living_base.getHeldItemStack()) + newline);
        }
        if ((worn_items = entity_living_base.getWornItems()) != null) {
            for (int i2 = 0; i2 < worn_items.length; ++i2) {
                sb2.append(" Worn[" + i2 + "]: " + EntityStatsDump.getItemStackDescriptorForStatsFile(worn_items[i2]) + newline);
            }
        }
        sb2.append(newline);
    }

    private static void appendSectionInventory(of entity_living_base, StringBuilder sb2) {
        sb2.append("Inventory" + newline);
        if (entity_living_base.isEntityPlayer()) {
            uf player = entity_living_base.getAsPlayer();
            boolean none = true;
            for (int i2 = 0; i2 < player.bn.a.length; ++i2) {
                ye item_stack = player.bn.a[i2];
                if (item_stack == null) continue;
                none = false;
                sb2.append(" " + (i2 < 9 ? "Hotbar" : "Extended") + "[" + i2 + "]: " + EntityStatsDump.getItemStackDescriptorForStatsFile(item_stack) + newline);
            }
            if (none) {
                sb2.append(" (none)" + newline);
            }
        } else if (entity_living_base instanceof og) {
            og entity_living = entity_living_base.getAsEntityLiving();
            ye[] contained_items = entity_living.getContainedItems();
            if (contained_items == null) {
                EntityLongdeadGuardian guardian;
                boolean has_inventory = false;
                if (entity_living_base instanceof EntityLongdeadGuardian && (guardian = (EntityLongdeadGuardian)entity_living_base).getStowedItemStack() != null) {
                    has_inventory = true;
                    sb2.append(" Stowed[0]: " + EntityStatsDump.getItemStackDescriptorForStatsFile(guardian.getStowedItemStack()) + newline);
                }
                if (!has_inventory) {
                    sb2.append(" (none)" + newline);
                }
            } else {
                for (int i3 = 0; i3 < contained_items.length; ++i3) {
                    sb2.append(" Contained[" + i3 + "]: " + EntityStatsDump.getItemStackDescriptorForStatsFile(contained_items[i3]) + newline);
                }
            }
        } else {
            sb2.append(" (Don't know how to handle)" + newline);
        }
    }

    private static String getMeleeDamageString(of entity_living_base) {
        float total_melee_damage = entity_living_base.isEntityPlayer() ? entity_living_base.getAsPlayer().calcRawMeleeDamageVs(null, false, false) : (entity_living_base.hasEntityAttribute(tp.e) ? (float)entity_living_base.getEntityAttributeValue(tp.e) : 0.0f);
        StringBuilder sb2 = new StringBuilder();
        sb2.append("Melee Damage: " + EntityStatsDump.customFloatFormat(total_melee_damage));
        if (total_melee_damage > 0.0f) {
            float damage_from_held_item;
            ye held_item_stack = entity_living_base.getHeldItemStack();
            float f2 = damage_from_held_item = held_item_stack == null ? 0.0f : held_item_stack.getMeleeDamageBonus();
            if (entity_living_base.isEntityPlayer()) {
                String level_modifier_melee_string;
                uf player = entity_living_base.getAsPlayer();
                int level_modifier_melee = Math.round(player.getLevelModifier(EnumLevelBonus.MELEE_DAMAGE) * 100.0f);
                float base_melee_damage = (float)entity_living_base.getEntityAttributeBaseValue(tp.e);
                String string = level_modifier_melee_string = level_modifier_melee == 0 ? "" : " + " + level_modifier_melee + "%";
                if (damage_from_held_item != 0.0f) {
                    sb2.append(" (" + base_melee_damage + " + " + held_item_stack.s() + ")" + level_modifier_melee_string);
                } else if (level_modifier_melee != 0) {
                    sb2.append(" (" + base_melee_damage + level_modifier_melee_string + ")");
                }
            } else if (damage_from_held_item > 0.0f) {
                sb2.append(" (" + EntityStatsDump.customFloatFormat(total_melee_damage - damage_from_held_item) + " + " + held_item_stack.s() + ")");
            }
        }
        return sb2.toString();
    }

    public static StringBuilder getStatsDump(String header, of entity_living_base) {
        uf player;
        StringBuilder sb2 = new StringBuilder();
        if (entity_living_base.onClient()) {
            sb2.append("* GENERATED ON CLIENT *" + newline + newline);
        }
        if (header == null) {
            header = entity_living_base.an();
        }
        sb2.append(header + newline);
        sb2.append(StringHelper.repeat("-", header.length()) + newline);
        sb2.append("UUID: " + entity_living_base.getUniqueIDSilent() + newline + newline);
        uf uf2 = player = entity_living_base.isEntityPlayer() ? entity_living_base.getAsPlayer() : null;
        if (player != null) {
            int phytonutrients;
            int protein;
            int level_modifier_harvesting = Math.round(player.getLevelModifier(EnumLevelBonus.HARVESTING) * 100.0f);
            int level_modifier_crafting = Math.round(player.getLevelModifier(EnumLevelBonus.CRAFTING) * 100.0f);
            int level_modifier_melee = Math.round(player.getLevelModifier(EnumLevelBonus.MELEE_DAMAGE) * 100.0f);
            sb2.append("Level: " + player.getExperienceLevel() + " (");
            sb2.append((level_modifier_harvesting < 0 ? "" : "+") + level_modifier_harvesting + "% harvesting, ");
            sb2.append((level_modifier_crafting < 0 ? "" : "+") + level_modifier_crafting + "% crafting, ");
            sb2.append((level_modifier_melee < 0 ? "" : "+") + level_modifier_melee + "% melee)" + newline);
            sb2.append("XP: " + player.bJ + newline + newline);
            sb2.append("Health: " + StringHelper.formatFloat(player.aN(), 1, 1) + "/" + player.aT() + newline + newline);
            sb2.append("Satiation: " + player.getSatiation() + "/" + player.getSatiationLimit() + newline);
            sb2.append("Nutrition: " + player.getNutrition() + "/" + player.getNutritionLimit() + newline + newline);
            if (player instanceof jv) {
                protein = player.getAsEntityPlayerMP().getProtein();
                phytonutrients = player.getAsEntityPlayerMP().getPhytonutrients();
            } else {
                phytonutrients = 0;
                protein = 0;
            }
            sb2.append("Protein: " + protein + " (" + 100 * protein / 160000 + "%)" + newline);
            sb2.append("Phytonutrients: " + phytonutrients + " (" + 100 * phytonutrients / 160000 + "%)" + newline + newline);
            sb2.append(EntityStatsDump.getMeleeDamageString(player) + newline + newline);
        } else {
            sb2.append("Health: " + StringHelper.formatFloat(entity_living_base.aN(), 1, 1) + "/" + entity_living_base.aT() + newline + newline);
            sb2.append(EntityStatsDump.getMeleeDamageString(entity_living_base) + newline + newline);
        }
        EntityStatsDump.appendSectionProtection(entity_living_base, sb2);
        EntityStatsDump.appendSectionResistance(entity_living_base, sb2);
        EntityStatsDump.appendSectionPotionEffects(entity_living_base, sb2);
        EntityStatsDump.appendSectionEquipment(entity_living_base, sb2);
        EntityStatsDump.appendSectionInventory(entity_living_base, sb2);
        if (entity_living_base.o instanceof of) {
            of riding_entity = entity_living_base.o.getAsEntityLivingBase();
            sb2.append(newline + EntityStatsDump.getStatsDump("Mount (" + riding_entity.an() + ")", riding_entity));
        }
        return sb2;
    }

    public static Packet94CreateFile generatePacketFor(of entity_living_base) {
        byte[] content = EntityStatsDump.getStatsDump(null, entity_living_base).toString().getBytes();
        StringBuilder filepath = new StringBuilder("MITE/stats/dump/");
        if (entity_living_base.isEntityPlayer()) {
            filepath.append(entity_living_base.an());
        } else {
            filepath.append(entity_living_base.an());
            filepath.append("/");
            filepath.append(entity_living_base.getUniqueIDSilent());
        }
        filepath.append(".txt");
        return new Packet94CreateFile(filepath.toString(), content).setOptions(1, true);
    }
}

